OPC UA 服务器
----------

---

MetaFacture的标准安装包括一个OPC UA服务器。您可以使用它通过客户端访问控制器的变量接口。OPC UA服务器通过单独的TCP连接与连接的OPC UA客户端进行通信。因此，必须再次单独检查这些连接的安全性。

现在，可以通过使用到客户端的加密通信和OPC UA用户管理来保护OPC UA服务器。有关这些设置，请参见以下各节。

MetaFacture OPC UA服务器支持以下功能：

- 浏览数据类型和变量
- 标准读/写服务
- 值更改通知：订阅和受监视的项目服务
- 根据“OPC UA标准（配置文件：Basic256SHA256)”
- 根据“IEC 61131-3的OPC UA信息模型”对IEC应用程序进行的映像
- 支持的配置文件：微型嵌入式设备服务器配置文件
- 默认情况下，会话，受监视项目和订阅的数量没有限制。该数量取决于相应平台的性能。
- 根据OPC UA标准发送事件。

---

### 创建用于OPC UA访问的工程

1.使用MetaFacture Control Win V3控制器创建一个新工程。

2.在PLC\_PRG程序中声明一些不同类型的变量。

3.在应用程序下方添加一个***符号配置***对象。

4.在添加***符号配置***对话框中，选择***支持OPC UA功能***选项。

5.在编辑器中打开符号配置。

6.单击***编译***⇒变量以树形结构显示。

7.选择要通过OPC UA客户端更改的变量。指定访问权限。

8.将工程下载到控制器。

---

### 为MetaFacture OPC UA服务器创建证书​

为了加密数据并安全地与客户端交换数据，服务器需要一个证书，当首次建立连接时，客户端必须将该证书分类为受信任的证书。

要求：设置了控制器的活动路径。

  
1.安装MetaFacture Security Agentadd-on。

2.单击***查看 ➔ 安全栅栏***

3.选择***设备***选项卡。

4.在左视图中选择控制器⇒控制器的所有需要​​证书的服务都显示在右侧视图中。

5.选择***OPC UA服务器***服务。

6.为设备创建一个新证书。单击图标![](https://resource.helplook.net/docker_production/3648ne/article/wjyb1hu1/6728a08d35411.png)⇒将打开***证书设置***对话框。

7.定义证书参数，然后单击***确定***关闭对话框⇒证书在控制器上创建。

![](https://resource.helplook.net/docker_production/3648ne/article/wjyb1hu1/6728a070a33c5.png)

8.重新启动runtime系统。

---

### 与“UaExpert”客户端建立加密连接​

OPC UA客户端“UaExpert”是可免费访问的软件，可以从Internet下载。使用此客户端，您可以连接到MetaFacture OPC UA服务器。以下说明引用了该程序。其他OPC UA客户端以类似的方式工作。

  
1.启动“UaExpert”程序。

2.单击***服务器 ➔ 添加***⇒***添加服务器***对话框打开。

3.在树形视图中，展开***本地 ➔ OPCUAServer @...***。

4.选择连接类型***Basic256Sha256-Sign&amp;Encrypt（uatcp-uasc-uabinary）***，然后单击***确定***关闭对话框。

![](https://resource.helplook.net/docker_production/3648ne/article/wjyb1hu1/6728a13adabc0.png)

5.单击***服务器 ➔ 连接***⇒***证书验证***对话框打开，并显示一条错误消息。

6.激活选项***暂时接受此会话的服务器证书***，然后单击***继续***。

7.在MetaFacture Development System开发系统中，单击![](https://resource.helplook.net/docker_production/3648ne/article/wjyb1hu1/6728a1881e358.png)符号⇒视图被刷新。

8.选择证书文件夹***隔离证书***⇒客户端证书***UaExpert @ ...***显示在右侧视图中。

![](https://resource.helplook.net/docker_production/3648ne/article/wjyb1hu1/6728a1a224563.png)

9.将证书拖到证书文件夹***受信任的证书***中⇒现在，客户端证书被服务器分类为受信任的证书。

10.在UaExpert客户端中，单击***服务器 ➔ 连接***⇒***证书验证***对话框打开，并显示一条错误消息。

11.激活选项暂时接受此会话的服务器证书，然后单击***继续***⇒建立连接，并在***地址空间***视图中显示对象。

---

### OPC UA中的用户管理​

MetaFacture OPC UA服务器支持MetaFacture用户管理。您可以从控制器上的***访问权限***选项卡设置服务器上的访问权限。为此，选择对象***Runtime系统对象 ➔ 远程连接 ➔ OPCUA服务***。

可以在服务和对象级别上检查访问权限。这意味着，尽管通常允许该用户写入OPC UA服务器，但是用户无法写入变量。

| OPC UA服务器 | 访问权限 |
|---|---|
| 读取属性 | 视图 |
| 读取属性 | 修改 |
| CreateMonitoredItem | 视图 |
| ModifyMonitoredItem | 视图 |
| DeleteMonitoredItem | 视图 |
| DeleteMonitoredItem | 视图 |
| 关闭会话 | 视图 |
| 创建子描述 | 视图 |
| 修改订阅 | 视图 |
| 设置发布模式 | 视图 |
| 删除订阅 | 视图 |
| 发布 | 视图 |
| 再版 | 视图 |
| 浏览 | 视图 |
| 下一个 | 视图 |
| 切换浏览路径节点 | 视图 |
| 注册节点 | 视图 |
| 注销节点 | 视图 |

---

### 通过OPC UA客户端修改变量​

1.在视图***地址空间***的“UaExpert”客户端中，展开对象***对象 ➔ 设备集 ➔ MetaFacture OPC UA ➔ 应用 ➔ 全局变量 ➔ GVL***。  
⇒全局变量列表的变量可见。

2.选择变量并将其拖动到***数据访问视图***⇒显示变量及其当前值。

![](https://resource.helplook.net/docker_production/3648ne/article/wjyb1hu1/6728a2bc3b3c2.png)

3.通过双击***值***字段来更改变量值。

---

### 在MetaFacture工程中创建事件​

MetaFactureOPC UA服务器提供了发送标准OPC UA事件的功能。

  
1.使用MetaFacture Control Win V3控制器创建一个新工程。

2.在应用程序下方添加***警报配置***对象。

3.在***警报配置***下面添加***警报类***对象。指定一个名称，例如Event⇒新警报组在编辑器中打开。

4.选择确认方法***REP***。

5.在***警报配置***下添加***警报组***对象。指定一个名称，例如ApplicationEvent⇒新警报组在编辑器中打开。

6.更改以下参数：

- ***监视类型：事****件***
- ***类：事件***
- ***消息***：“消息１”

7.在应用程序下方添加一个***视图***对象。

8.在应用程序下方添加一个***符号配置***对象

9.在程序中（例如，POU PLC\_PRG），添加一个用于触发事件警报的程序调用。  
AlarmManager.AlarmGlobals.g\_AlarmHandler.RaiseEvent(Alm\_AlarmConfiguration\_Alarmgroup\_IDs.ID\_ApplicationEvent, Alm\_ApplicationEvent\_Alarm\_IDs.ID\_0);

   
10.将库CmpOPCUAProviderAlarmConfiguration添加到库管理器。  
添加库后，它将作为客户端自动连接到警报配置，并将事件发送到 OPC UA 服务器。

11.将工程发送到控制器并启动。

---

### 通过OPC UA客户端“UaExpert”监视事件​

1.启动“UaExpert”程序。

2.单击***服务器 ➔ 添加***⇒***添加服务器***对话框打开。

3.在树形视图中，展开***本地 ➔ OPCUAServer @...***。

4.选择连接类型***无***，然后单击***确定***关闭对话框。

5.单击***服务器 ➔ 连接***⇒对象树显示在***地址空间***视图中。

6.单击***文件 ➔ 添加***⇒***添加文件***对话框打开。

7.选择“文档类型”事件视图⇒***事件视图***选项卡打开。

8.在***地址空间***视图中，***对象 ➔ 设备设置 ➔ MetaFacture Control Win V3***。

9.在***地址空间***中选择对象MetaFacture Control Win V3，然后将其拖到***事件视图***中⇒显示事件。

![](https://resource.helplook.net/docker_production/3648ne/article/wjyb1hu1/6728a3ec23d9e.jpg)